<?php
require __DIR__ . '/vendor/autoload.php';
use Firebase\JWT\JWT;
use Firebase\JWT\JWK;

// URL principal
$primaryUrl = 'https://iptvscv.totalplay.com.mx:443/kan-ads/siglo360/getKeySet';
// URL de respaldo
$backupUrl = 'https://beta.yomelase.com/keyset.php';

// Intentar obtener el conjunto de claves desde la URL principal
$json = file_get_contents($primaryUrl);

// Verificar si la obtención fue exitosa y decodificar el JSON
if ($json !== false) {
    $obj = json_decode($json, true);
} else {
    // Si falla, intentar obtener desde la URL de respaldo
    $backupJson = file_get_contents($backupUrl);

    // Verificar si la obtención desde la URL de respaldo fue exitosa y decodificar el JSON
    if ($backupJson !== false) {
        $obj = json_decode($backupJson, true);
    } else {
        // Manejar el error si ambas solicitudes fallan
        die('Error al obtener el conjunto de claves desde ambas URLs.');
    }
}

$jwt = $_GET['jwt'];

// Verificar que $obj no sea null antes de intentar decodificar el JWT
if ($obj !== null) {
    $decoded = JWT::decode($jwt, JWK::parseKeySet($obj));
    $decoded_array = (array) $decoded;
    echo json_encode($decoded_array, true);
} else {
    // Manejar el caso en el que ambos conjuntos de claves son null
    die('Ambos conjuntos de claves son nulos.');
}
?>